package com.ejie.ab04b.model;

import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;

/**
 * ReenvioComunicaciones NO generated by UDA, 27-sep-2016 13:26:07.
 * 
 * @author NO UDA
 */

public class CierreMasivo implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	// Clave compuesta
	private String territorioExpediente077;
	private String periodoPresentacion;
	private String fecpreDesdeStr;
	private String fecpreHastaStr;
	private String tipoPresentacion;

	private String terape;
	private String anoape;
	private Long numape;

	private String numos;// Lo uso en el export a excel para el campo numero de
							// expediente
	private String numdoc;
	private Date fecpre;
	private String nomemp;
	private Date fecpreDesde;
	private Date fecpreHasta;

	// Filtro
	private String indobra;
	private String visosl;
	private String indInfOsalan;
	private String indInfInsp;

	/**
	 * Method 'ReenvioComunicaciones'.
	 */
	public CierreMasivo() {
	}

	/**
	 * Instantiates a new cierre masivo.
	 * 
	 * terape the terape anoape the anoape numape the numape numdoc the numdoc
	 * fecpre the fecpre nomemp the nomemp
	 * 
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape
	 * @param numdoc
	 *            the numdoc
	 * @param fecpre
	 *            the fecpre
	 * @param nomemp
	 *            the nomemp
	 */
	public CierreMasivo(String terape, String anoape, Long numape,
			String numdoc, Date fecpre, String nomemp) {
		this.terape = terape;
		this.anoape = anoape;
		this.numape = numape;
		this.numos = terape + "/" + anoape + "/" + numape;
		this.numdoc = numdoc;
		this.fecpre = fecpre;
		this.nomemp = nomemp;
	}

	/**
	 * Instantiates a new cierre masivo.
	 * 
	 * terape the terape anoape the anoape numape the numape fecpre the fecpre
	 * nomemp the nomemp numdoc the numdoc
	 * 
	 * @param terape
	 *            the terape
	 * @param anoape
	 *            the anoape
	 * @param numape
	 *            the numape
	 * @param fecpre
	 *            the fecpre
	 * @param nomemp
	 *            the nomemp
	 * @param numdoc
	 *            the numdoc
	 */
	public CierreMasivo(String terape, String anoape, Long numape, Date fecpre,
			String nomemp, String numdoc) {
		this.terape = terape;
		this.anoape = anoape;
		this.numape = numape;
		this.numos = terape + "/" + anoape + "/" + numape;
		this.numdoc = numdoc;
		this.fecpre = fecpre;
		this.nomemp = nomemp;
	}

	/**
	 * Gets the territorio expediente 077.
	 * 
	 * the territorio expediente 077
	 * 
	 * @return the territorio expediente 077
	 */
	public String getTerritorioExpediente077() {
		return territorioExpediente077;
	}

	/**
	 * Sets the territorio expediente 077.
	 * 
	 * territorioExpediente077 the new territorio expediente 077
	 * 
	 * @param territorioExpediente077
	 *            the new territorio expediente 077
	 */
	public void setTerritorioExpediente077(String territorioExpediente077) {
		this.territorioExpediente077 = territorioExpediente077;
	}

	/**
	 * Gets the periodo presentacion.
	 * 
	 * the periodo presentacion
	 * 
	 * @return the periodo presentacion
	 */
	public String getPeriodoPresentacion() {
		return periodoPresentacion;
	}

	/**
	 * Sets the periodo presentacion.
	 * 
	 * periodoPresentacion the new periodo presentacion
	 * 
	 * @param periodoPresentacion
	 *            the new periodo presentacion
	 */
	public void setPeriodoPresentacion(String periodoPresentacion) {
		this.periodoPresentacion = periodoPresentacion;
	}

	/**
	 * Gets the tipo presentacion.
	 * 
	 * the tipo presentacion
	 * 
	 * @return the tipo presentacion
	 */
	public String getTipoPresentacion() {
		return tipoPresentacion;
	}

	/**
	 * Sets the tipo presentacion.
	 * 
	 * tipoPresentacion the new tipo presentacion
	 * 
	 * @param tipoPresentacion
	 *            the new tipo presentacion
	 */
	public void setTipoPresentacion(String tipoPresentacion) {
		this.tipoPresentacion = tipoPresentacion;
	}

	/**
	 * Gets the serialversionuid.
	 * 
	 * the serialversionuid
	 * 
	 * @return the serialversionuid
	 */
	public static long getSerialversionuid() {
		return serialVersionUID;

	}

	/**
	 * Gets the fecpre desde str.
	 * 
	 * String
	 * 
	 * @return the fecpre desde str
	 */
	public String getFecpreDesdeStr() {
		return Utilities.getInstance().formatearDateIdioma(this.fecpreDesde);
	}

	/**
	 * Method 'setFecentDesde'.
	 * 
	 * fecpreDesde Date
	 * 
	 * @param fecpreDesde
	 *            the new fecpre desde str
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecpreDesdeStr(Date fecpreDesde) {
		this.fecpreDesde = fecpreDesde;
	}

	/**
	 * Gets the fecpre hasta str.
	 * 
	 * String
	 * 
	 * @return the fecpre hasta str
	 */
	public String getFecpreHastaStr() {
		return Utilities.getInstance().formatearDateIdioma(this.fecpreHasta);
	}

	/**
	 * Method 'setFecentHasta'.
	 * 
	 * fecpreHasta Date
	 * 
	 * @param fecpreHasta
	 *            the new fecpre hasta str
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecpreHastaStr(Date fecpreHasta) {
		this.fecpreHasta = fecpreHasta;
	}

	/**
	 * Gets the terape.
	 * 
	 * the terape
	 * 
	 * @return the terape
	 */
	public String getTerape() {
		return terape;
	}

	/**
	 * Sets the terape.
	 * 
	 * terape the new terape
	 * 
	 * @param terape
	 *            the new terape
	 */
	public void setTerape(String terape) {
		this.terape = terape;
	}

	/**
	 * Gets the anoape.
	 * 
	 * the anoape
	 * 
	 * @return the anoape
	 */
	public String getAnoape() {
		return anoape;
	}

	/**
	 * Sets the anoape.
	 * 
	 * anoape the new anoape
	 * 
	 * @param anoape
	 *            the new anoape
	 */
	public void setAnoape(String anoape) {
		this.anoape = anoape;
	}

	/**
	 * Gets the numape.
	 * 
	 * the numape
	 * 
	 * @return the numape
	 */
	public Long getNumape() {
		return numape;
	}

	/**
	 * Sets the numape.
	 * 
	 * numape the new numape
	 * 
	 * @param numape
	 *            the new numape
	 */
	public void setNumape(Long numape) {
		this.numape = numape;
	}

	/**
	 * Gets the numdoc.
	 * 
	 * the numdoc
	 * 
	 * @return the numdoc
	 */
	public String getNumdoc() {
		return numdoc;
	}

	/**
	 * Sets the numdoc.
	 * 
	 * numdoc the new numdoc
	 * 
	 * @param numdoc
	 *            the new numdoc
	 */
	public void setNumdoc(String numdoc) {
		this.numdoc = numdoc;
	}

	/**
	 * Gets the fecpre.
	 * 
	 * the fecpre
	 * 
	 * @return the fecpre
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecpre() {
		return fecpre;
	}

	/**
	 * Sets the fecpre.
	 * 
	 * fecpre the new fecpre
	 * 
	 * @param fecpre
	 *            the new fecpre
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecpre(Date fecpre) {
		this.fecpre = fecpre;
	}

	/**
	 * Gets the nomemp.
	 * 
	 * the nomemp
	 * 
	 * @return the nomemp
	 */
	public String getNomemp() {
		return nomemp;
	}

	/**
	 * Sets the nomemp.
	 * 
	 * nomemp the new nomemp
	 * 
	 * @param nomemp
	 *            the new nomemp
	 */
	public void setNomemp(String nomemp) {
		this.nomemp = nomemp;
	}

	/**
	 * Gets the numos.
	 * 
	 * the numos
	 * 
	 * @return the numos
	 */
	public String getNumos() {
		return numos;
	}

	/**
	 * @return the indobra
	 */
	public String getIndobra() {
		return indobra;
	}

	/**
	 * @param indobra
	 *            the indobra to set
	 */
	public void setIndobra(String indobra) {
		this.indobra = indobra;
	}

	/**
	 * @return the visosl
	 */
	public String getVisosl() {
		return visosl;
	}

	/**
	 * @param visosl
	 *            the visosl to set
	 */
	public void setVisosl(String visosl) {
		this.visosl = visosl;
	}

	/**
	 * @return the indInfOsalan
	 */
	public String getIndInfOsalan() {
		return indInfOsalan;
	}

	/**
	 * @param indInfOsalan
	 *            the indInfOsalan to set
	 */
	public void setIndInfOsalan(String indInfOsalan) {
		this.indInfOsalan = indInfOsalan;
	}

	/**
	 * @return the indInfInsp
	 */
	public String getIndInfInsp() {
		return indInfInsp;
	}

	/**
	 * @param indInfInsp
	 *            the indInfInsp to set
	 */
	public void setIndInfInsp(String indInfInsp) {
		this.indInfInsp = indInfInsp;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "ReenvioComunicaciones [territorioExpediente077="
				+ territorioExpediente077 + ", periodoPresentacion="
				+ periodoPresentacion + ", fecpreDesdeStr=" + fecpreDesdeStr
				+ ", fecpreHastaStr=" + fecpreHastaStr + ", tipoPresentacion="
				+ tipoPresentacion + ", terape=" + terape + ", anoape="
				+ anoape + ", numape=" + numape + ", numos=" + numos
				+ ", numdoc=" + numdoc + ", fecpre=" + fecpre + ", nomemp="
				+ nomemp + "]";
	}

}